<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// DB credentials
$host = "127.0.0.1";
$dbname = "tedbeer";
$username = "tedbeer";
$password = "ZRF14q*QjBei";
$port = 3306;

// Connect
try {
    $pdo = new PDO("mysql:host=$host;port=$port;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    echo json_encode(["status"=>"error","message"=>"DB failed","error"=>$e->getMessage()]);
    exit;
}

$path = $_GET["path"] ?? "";

switch($path) {
    case "test":
        echo json_encode(["status"=>"success","message"=>"DB OK"]);
        break;

    case "tokens": // Create new token
        if ($_SERVER["REQUEST_METHOD"]==="POST") {
            $name = $_POST["visitor_name"] ?? "";
            $purpose = $_POST["visit_purpose"] ?? "";
            $phone = $_POST["phone"] ?? "";
            $priority = $_POST["priority"] ?? "NORMAL";

            if (!$name || !$purpose) {
                http_response_code(400);
                echo json_encode(["status"=>"error","message"=>"Missing fields"]);
                exit;
            }

            // Get next number
            $stmt = $pdo->prepare("SELECT MAX(token_number) FROM visitor_tokens WHERE issue_date=CURDATE()");
            $stmt->execute();
            $next = $stmt->fetchColumn();
            $next = $next ? $next+1 : 1;

            $stmt = $pdo->prepare("INSERT INTO visitor_tokens (token_number,visitor_name,visit_purpose,phone,priority,status,issue_date,issue_time) VALUES (?,?,?,?,?,'PENDING',CURDATE(),CURTIME())");
            $stmt->execute([$next,$name,$purpose,$phone,$priority]);
            $id = $pdo->lastInsertId();

            echo json_encode([
                "status"=>"success",
                "data"=>[
                    "id"=>$id,
                    "token_number"=>$next,
                    "visitor_name"=>$name,
                    "visit_purpose"=>$purpose,
                    "priority"=>$priority
                ]
            ]);
        }
        break;

    case "today": // All today tokens
        $stmt = $pdo->prepare("SELECT * FROM visitor_tokens WHERE issue_date=CURDATE() ORDER BY FIELD(priority,'URGENT','HIGH','NORMAL'), token_number ASC");
        $stmt->execute();
        echo json_encode(["status"=>"success","data"=>$stmt->fetchAll(PDO::FETCH_ASSOC)]);
        break;

    case "update": // Update status
        if ($_SERVER["REQUEST_METHOD"]==="PUT") {
            parse_str(file_get_contents("php://input"), $_PUT);
            $id = $_PUT["id"] ?? 0;
            $status = $_PUT["status"] ?? "";
            if (!$id || !$status) {
                http_response_code(400);
                echo json_encode(["status"=>"error","message"=>"Missing id/status"]);
                exit;
            }
            $stmt = $pdo->prepare("UPDATE visitor_tokens SET status=?,updated_at=NOW() WHERE id=?");
            $stmt->execute([$status,$id]);
            echo json_encode(["status"=>"success","message"=>"Updated"]);
        }
        break;

    case "stats": // Today stats
        $stmt = $pdo->prepare("SELECT 
            COUNT(*) total,
            SUM(status='PENDING') pending,
            SUM(status='IN_PROGRESS') in_progress,
            SUM(status='COMPLETED') completed
            FROM visitor_tokens WHERE issue_date=CURDATE()");
        $stmt->execute();
        echo json_encode(["status"=>"success","data"=>$stmt->fetch(PDO::FETCH_ASSOC)]);
        break;

    default:
        http_response_code(404);
        echo json_encode(["status"=>"error","message"=>"Unknown path"]);
}
