<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSiteInformationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_information', function (Blueprint $table) {
            $table->id();


            $table->string('contact_request_title_en')->nullable();
            $table->string('contact_request_title_ar')->nullable();

            $table->string('brand_name_en')->nullable();
            $table->string('brand_name_ar')->nullable();

            $table->string('logo')->nullable();
            $table->string('logo_webp')->nullable();
            $table->string('logo_attribute')->nullable();


            $table->string('tadbeer_logo')->nullable();
            $table->string('tadbeer_logo_webp')->nullable();
            $table->string('tadbeer_logo_attribute')->nullable();

            $table->string('phone')->nullable();
            $table->string('alternate_phone')->nullable();
            $table->string('whatsapp_number')->nullable();

            $table->text('location_en')->nullable();
            $table->text('location_ar')->nullable();

            $table->text('google_map')->nullable();
            $table->string('email')->nullable();
            $table->string('alternate_email')->nullable();
            $table->string('email_recipient')->nullable();
            $table->text('working_hours_en')->nullable();
            $table->text('working_hours_ar')->nullable();

            $table->string('facebook_url')->nullable();
            $table->string('instagram_url')->nullable();
            $table->string('snapchat_url')->nullable();
            $table->string('pinterest_url')->nullable();
            $table->string('linkedin_url')->nullable();
            $table->string('youtube_url')->nullable();
            $table->string('twitter_url')->nullable();

            //policies
            $table->text('copyright_en')->nullable();
            $table->text('copyright_ar')->nullable();
            $table->longText('privacy_policy_en')->nullable();
            $table->longText('privacy_policy_ar')->nullable();
            $table->longText('terms_and_conditions_en')->nullable();
            $table->longText('terms_and_conditions_ar')->nullable();
            $table->longText('footer_location_en')->nullable();
            $table->longText('footer_location_ar')->nullable();

            // seo related
            $table->longText('header_tag')->nullable();
            $table->longText('footer_tag')->nullable();
            $table->longText('body_tag')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_information');
    }
}
