<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBlogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title_en');
            $table->string('title_ar');
            $table->string('short_url')->nullable();
            $table->string('sub_title_en');
            $table->string('sub_title_ar');
            $table->date('posted_date')->nullable();
            $table->string('written_by_en')->nullable();
            $table->string('written_by_ar')->nullable();
            $table->longText('image')->nullable();
            $table->longText('webp_image')->nullable();
            $table->string('image_meta_tag')->nullable();
            $table->longText('list_description_en')->nullable();
            $table->longText('list_description_ar')->nullable();
            $table->longText('description_en')->nullable();
            $table->longText('description_ar')->nullable();
            $table->text('video_url')->nullable();
            $table->longText('video_thumbnail_image')->nullable();
            $table->longText('video_thumbnail_webp_image')->nullable();
            $table->string('video_meta_tag')->nullable();
            $table->longText('alternate_description_en')->nullable();
            $table->longText('alternate_description_ar')->nullable();
            $table->string('banner_title_en')->nullable();
            $table->string('banner_title_ar')->nullable();
            $table->text('banner_image')->nullable();
            $table->text('banner_webp_image')->nullable();
            $table->text('banner_attribute')->nullable();
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('meta_keyword')->nullable();
            $table->string('other_meta_tag')->nullable();
            $table->enum('status', ['Active', 'Inactive'])->default('Active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blogs');
    }
}
