<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAboutUsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('about_us', function (Blueprint $table) {
            $table->id();
            $table->string('title_en');
            $table->string('title_ar');
            $table->string('sub_title_en');
            $table->string('sub_title_ar');
            $table->text('description_en');
            $table->text('description_ar');
            $table->longText('alternate_description_en')->nullable();
            $table->longText('alternate_description_ar')->nullable();

            $table->text('first_image')->nullable();
            $table->text('first_image_webp')->nullable();
            $table->text('second_image')->nullable();
            $table->text('second_image_webp')->nullable();
            $table->text('image_attribute')->nullable();
            $table->string('image_title_en')->nullable();
            $table->string('image_title_ar')->nullable();
            $table->string('image_sub_title_en')->nullable();
            $table->string('image_sub_title_ar')->nullable();

            $table->string('alternate_title_en')->nullable();
            $table->string('alternate_title_ar')->nullable();
            $table->string('alternate_sub_title_en')->nullable();
            $table->string('alternate_sub_title_ar')->nullable();
            $table->longText('second_alternate_description_en')->nullable();
            $table->longText('second_alternate_description_ar')->nullable();
            $table->string('button_text_en')->nullable();
            $table->string('button_text_ar')->nullable();
            $table->string('button_url')->nullable();

            $table->string('mission_title_en')->nullable();
            $table->string('mission_title_ar')->nullable();
            $table->string('mission_sub_title_en')->nullable();
            $table->string('mission_sub_title_ar')->nullable();
            $table->longText('mission_description_en')->nullable();
            $table->longText('mission_description_ar')->nullable();
            $table->text('mission_image')->nullable();
            $table->text('mission_image_webp')->nullable();
            $table->text('mission_image_attribute')->nullable();

            $table->string('vision_title_en')->nullable();
            $table->string('vision_title_ar')->nullable();
            $table->string('vision_sub_title_en')->nullable();
            $table->string('vision_sub_title_ar')->nullable();
            $table->longText('vision_description_en')->nullable();
            $table->longText('vision_description_ar')->nullable();
            $table->text('vision_image')->nullable();
            $table->text('vision_image_webp')->nullable();
            $table->text('vision_image_attribute')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('about_us');
    }
}
