<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTestimonialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('testimonials', function (Blueprint $table) {
            $table->id();
            $table->string('name_en');
            $table->string('name_ar');
            $table->string('designation_en')->nullable();
            $table->string('designation_ar')->nullable();
            $table->string('title_en');
            $table->string('title_ar');
            $table->longtext('message_en');
            $table->longtext('message_ar');
            $table->integer('rating');
            $table->enum('review_type', ['Normal', 'Google'])->default('Normal');
            $table->text('image')->nullable();
            $table->text('webp_image')->nullable();
            $table->text('image_attribute')->nullable();
            $table->integer('sort_order');
            $table->enum('status', ['Active', 'Inactive'])->default('Active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('testimonials');
    }
}
