<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('home_banners', function (Blueprint $table) {
            $table->id();
            $table->string('title_en');
            $table->string('title_ar');
            $table->string('description_en');
            $table->string('description_ar');
            $table->string('image')->nullable();
            $table->string('image_webp')->nullable();
            $table->text('image_meta_tag')->nullable();
            $table->string('button_txt_en');
            $table->string('button_txt_ar');
            $table->string('button_url')->nullable();
            $table->integer('sort_order')->nullable();
            $table->enum('show_enquiry', ['Yes', 'No'])->default('Yes');
            $table->enum('status', ['Active', 'Inactive'])->default('Active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('home_banners');
    }
};
