<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Maid extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Scope a query to only include active items.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'Active');
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function services()
    {
        return $this->belongsToMany(Service::class, 'maid_services', 'maid_id', 'service_id');
    }


    public function maid_service()
    {
        return $this->belongsToMany(MaidService::class, 'maid_skill_sets', 'maid_id', 'skill_set_id');
    }


    public function skill_sets()
    {
        return $this->belongsToMany(SkillSet::class, 'maid_skill_sets', 'maid_id', 'skill_set_id');
    }
}
