<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Enquiry extends Model
{
    use HasFactory,SoftDeletes;

    public function maid()
    {
        return $this->belongsTo(Maid::class);
    }

    public function visa_service()
    {
        return $this->belongsTo(VisaService::class);
    }

    public function services()
    {
        return $this->belongsToMany(Service::class, 'enquiry_services', 'enquiry_id', 'service_id');
    }

}
