<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\AboutBoxContent;
use App\Models\AboutUs;
use App\Models\Banner;
use App\Models\Blog;
use App\Models\BlogListPageHeading;
use App\Models\Contact;
use App\Models\ContactAddress;
use App\Models\Country;
use App\Models\Designation;
use App\Models\Enquiry;
use App\Models\EnquiryForm;
use App\Models\ExtraTag;
use App\Models\HomeAboutUs;
use App\Models\HomeBanner;
use App\Models\HomeContactUs;
use App\Models\HomeHeading;
use App\Models\HomeMediaHeading;
use App\Models\HomeServiceHeading;
use App\Models\HomeTestimonialHeading;
use App\Models\KeyFeature;
use App\Models\Maid;
use App\Models\MetaTag;
use App\Models\Newsletter;
use App\Models\Partner;
use App\Models\PartnersAddress;
use App\Models\Service;
use App\Models\ServiceDetailsPageHeading;
use App\Models\SiteInformation;
use App\Models\Team;
use App\Models\TeamDetailsPageHeading;
use App\Models\TeamListPageHeading;
use App\Models\Testimonial;
use App\Models\TeamPage;
use App\Models\VisaService;
use App\Models\VisaServicePage;
use App\Models\WebsiteLanguage;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
date_default_timezone_set('Asia/Dubai');
class HomeController extends Controller
{
    public function __construct()
    {
        $siteInformation = SiteInformation::first();
        $websiteLanguages = WebsiteLanguage::get();
        $allServices = Service::active()->orderBy('sort_order')->get();
        View::share(compact('siteInformation', 'websiteLanguages', 'allServices'));
    }

    public function seo_content($type, $page_name, $key = NULL)
    {
        if ($type == 1) {
            $meta_data = MetaTag::where('page_name', $page_name)->first();
            return $meta_data;
        } else {
            $model = 'App\\Models\\' . $page_name;
            $meta_data = $model::find($key);
            return $meta_data;
        }
    }

    public function set_language(Request $request)
    {
        $language = $request->language;
        session(['language' => $request->language_code]);
        App::setlocale($request->language_code);
        return response(array(
            'status' => true,
            'message' => "Language changed to '" . $language . "'",
        ), 200, []);
    }

    public function home()
    {
        $meta_data = $this->seo_content(1, 'Home');
        $homeBanners = HomeBanner::active()->orderBy('sort_order')->get();
        $homeAbout = HomeAboutUs::first();
        $keyfeature = KeyFeature::active()->take(4)->oldest('sort_order')->get();
        $services = Service::active()->where('display_to_home', 'Yes')->orderBy('sort_order')->get();
        $testimonials = Testimonial::active()->orderBy('sort_order')->get();
        $testimonialHeading = HomeHeading::where('type', 'testimonial')->first();
        $blogs = Blog::active()->latest('posted_date')->take(8)->get();
        $blogHeading = HomeHeading::where('type', 'blog')->first();
        $serviceHeading = HomeHeading::where('type', 'service')->first();
        $teamHome = TeamPage::first();
        $maids = Maid::active()->where('display_to_home', 'Yes')->get();
//        dd($testimonials);
        $meta_data = $this->seo_content(1, 'Home');
        return view('web.index', compact('homeBanners', 'keyfeature', 'homeAbout', 'meta_data',
            'services', 'testimonials', 'blogs', 'meta_data', 'serviceHeading', 'teamHome', 'maids', 'blogHeading', 'testimonials', 'testimonialHeading'));
    }

    public function about()
    {
        $banner = Banner::where('type', 'About')->first();
        $about = AboutUs::first();
        $meta_data = $this->seo_content(1, 'About');
        return view('web.about', compact('banner', 'about', 'meta_data'));
    }

    public function services()
    {
        $banner = Banner::where('type', 'Services')->first();
        $services = Service::active()->orderBy('sort_order')->get();
        $blogHeading = HomeHeading::where('type', 'blog')->first();
        $blogs = Blog::active()->latest('posted_date')->take(8)->get();
        $meta_data = $this->seo_content(1, 'Services');
        return view('web.services', compact('banner', 'services', 'blogs', 'blogHeading', 'meta_data'));
    }

    public function maids()
    {
        $banner = Banner::where('type', 'Maids')->first();
        $countries = Country::active()->get();
        $condition = Maid::with('services', 'skill_sets')->active();
        $totalmaids = $condition->count();
        $maids = $condition->latest()->take(4)->get();
        $offset = $maids->count();
        $loading_limit = 4;

        $meta_data = $this->seo_content(1, 'Maids');
        return view('web.maids', compact('banner', 'countries', 'totalmaids', 'offset', 'loading_limit', 'maids', 'meta_data'));
    }

    public function maid_detail($maid_id)
    {
        $banner = Banner::where('type', 'Maids')->first();
        $countries = Country::active()->get();
        $condition = Maid::where('maid_id', $maid_id)->with('services', 'skill_sets')->active();
        $totalmaids = $condition->count();
        $maids = $condition->latest()->get();
        $offset = $maids->count();
        $loading_limit = 4;

        $meta_data = $this->seo_content(1, 'Maids');
        return view('web.maids', compact('banner', 'countries', 'totalmaids', 'offset', 'loading_limit', 'maids', 'meta_data'));
    }


    public function maidLoadMore(Request $request)
    {

//        $condition = Maid::with('services', 'skill_sets')->active();
        $condition = $this->filterCondition($request);
        $offset = $request->maid_loading_offset;
        $loading_limit = $request->maid_loading_limit;
        $totalmaids = $condition->count();
        $maids = $condition->latest()->skip($offset)->take($loading_limit)->get();
        $offset += $maids->count();

        return view('web.includes._maid_list', compact('maids', 'loading_limit', 'totalmaids', 'offset'));
    }


    public function blog()
    {
        $banner = Banner::where('type', 'Blog')->first();
        $condition = Blog::active()->latest('posted_date');
        $totalBlog = $condition->count();
        $blogs = $condition->take(12)->get();
        $offset = $blogs->count();
        $loading_limit = 9;
        $meta_data = $this->seo_content(1, 'Blog');
        return view('web.blog', compact('banner', 'blogs', 'blogs', 'meta_data', 'totalBlog', 'offset', 'loading_limit'));
    }

    public function blogLoadMore(Request $request)
    {
        $offset = $request->offset;
        $loading_limit = $request->loading_limit;
        $condition = Blog::active()->latest('posted_date');
        $totalBlog = $condition->count();
        $blogs = $condition->latest('posted_date')->skip($offset)->take($loading_limit)->get();
        $offset += $blogs->count();

        return view('web.includes._blog_list', compact('blogs', 'loading_limit', 'totalBlog', 'offset', 'blogs',));
    }


    public function blog_detail($short_url)
    {
        $blog = Blog::active()->where('short_url', $short_url)->first();
        if ($blog) {
            $banner = $blog;
            $recentBlogs = Blog::active()->where('id', '!=', $blog->id)->latest('posted_date')->take(3)->get();
            $previousItem = Blog::active()->where('id', '<', $blog->id)->orderBy('id', 'desc')->first();
            $nextItem = Blog::active()->where('id', '>', $blog->id)->orderBy('id', 'asc')->first();
            $meta_data = $this->seo_content(0, 'Blog', $blog->id);
            return view('web.blog-details', compact('blog', 'banner', 'previousItem', 'nextItem', 'recentBlogs', 'meta_data'));
        } else {
            return view('web.error.404');
        }
    }

    public function visa_service()
    {
        $banner = Banner::where('type', 'Visa-services')->first();
        $visaPage = VisaServicePage::first();
        $visaServices = VisaService::active()->get();
        $meta_data = $this->seo_content(1, 'Visa-services');
        return view('web.visa-service', compact('banner', 'visaServices', 'visaPage', 'meta_data'));
    }

    public function contact_us()
    {
        $banner = Banner::where('type', 'Contact')->first();
        $meta_data = $this->seo_content(1, 'Contact');
        return view('web.contact_us', compact('banner', 'meta_data'));
    }

    public function enquiry_store(Request $request)
    {
        $type = $request->prefixKey;
        $m_type = $type;
        if ($type == 'contact_page') $m_type = 'main_enquiry';
        if (filter_var($request[$type . '_email'], FILTER_VALIDATE_EMAIL)) {
            $enquiry = new EnquiryForm();
            $enquiry->type = $m_type;
            $enquiry->name = isset($request[$type . '_name']) ? $request[$type . '_name'] : '';
            $enquiry->email = isset($request[$type . '_email']) ? $request[$type . '_email'] : '';
            $enquiry->phone = isset($request[$type . '_phone']) ? $request[$type . '_phone'] : '';
            $enquiry->message = isset($request[$type . '_message']) ? $request[$type . '_message'] : '';
            $enquiry->company = isset($request[$type . '_company']) ? $request[$type . '_company'] : '';
            $enquiry->subject = isset($request[$type . '_subject']) ? $request[$type . '_subject'] : '';
            $enquiry->service_id = isset($request[$type . '_service_id']) ? $request[$type . '_service_id'] : 0;
            

            if ($enquiry->save()) {
                if ($type == 'service_enquiry') {
                    $sendContactMail = SendServiceEnquiryMail($enquiry);
                    if ($sendContactMail) {
                        echo json_encode(array('status' => 'success', 'message' => 'Service request has been submitted successfully'));
                    } else {
                        echo json_encode(array('status' => 'success', 'message' => "Service request has been submitted successfully,Can't sent the mail right now"));
                    }
                } else {
                    $sendContactMail = SendContactMail($enquiry);
                    if ($sendContactMail) {
                        echo json_encode(array('status' => 'success', 'message' => 'Contact request has been submitted successfully'));
                    } else {
                        echo json_encode(array('status' => 'success', 'message' => "Contact request has been submitted successfully,Can't sent the mail right now"));
                    }
                }
            } else {
                echo json_encode(array('status' => 'false', 'message' => 'Error : Error while submitting the contact request'));
            }
        } else {
            echo json_encode(array('status' => 'validation', 'message' => 'Error : Please enter a valid email id'));
        }
    }

    public function terms_and_conditions()
    {
        $banner = Banner::where('type', 'Terms')->first();
        $meta_data = $this->seo_content(1, 'Terms');

        return view('web.terms_and_conditions', compact('banner', 'meta_data'));
    }

    public function privacy_policy()
    {
        $banner = Banner::where('type', 'Privacy')->first();
        $meta_data = $this->seo_content(1, 'Privacy');
        return view('web.privacy_policy', compact('banner', 'meta_data'));
    }

    public function newsletter(Request $request)
    {
        $validatedData = $request->validate([
            'email' => 'required|email',
        ]);
        $existEntry = Newsletter::where('email', $validatedData['email'])->count();
        if ($existEntry == 0) {
            $contact = new Newsletter;
            $contact->email = $validatedData['email'];
            if ($contact->save()) {
                return response()->json(['status' => 'success', 'message' => 'Newsletter subscribed successfully']);
            } else {
                return response()->json(['status' => 'error', 'message' => 'Error while submit the request']);
            }
        } else {
            return response()->json(['status' => 'error', 'message' => '"' . $request->email . '" already subscribed']);
        }
    }

    public function enquiry(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|max:60',
            'phone' => 'required|regex:/^([0-9\+]*)$/|min:7|max:17',
            'message' => 'required',
            'email' => 'required|email',
        ]);
        $enquiry = new Enquiry();
        $enquiry->type = $request->type;
        $enquiry->name = $validatedData['name'];
        $enquiry->phone = $validatedData['phone'];
        $enquiry->message = $validatedData['message'];
        $enquiry->email = $validatedData['email'];
        $enquiry->request_url = url()->previous();
        $enquiry->preferrddate = $request['preferrddate'];
            $enquiry->preferrdtime = $request['preferrdtime'];
            $enquiry->created_at =date('Y-m-d H:i:s');
            $enquiry->updated_at =date('Y-m-d H:i:s');

        $enquiry->visa_service_id = $request->visa_service_id ?? NULL;
        $enquiry->maid_id = $request->maid_id ?? NULL;

//        $sendContactMail = SendContactMail($enquiry);
//        if ($sendContactMail) {
//            echo json_encode(array('status' => 'success', 'message' => 'Enquiry Send successfully'));
//        } else {
//            echo json_encode(array('status' => 'success', 'message' => "Error while submit the request"));
//        }

        if ($enquiry->save()) {
            $enquiry->services()->sync($request->services);

            if($request->services){
                $sendContactMail = SendServiceEnquirytMail($enquiry);
            }else{
                $sendContactMail = SendContactMail($enquiry);
            }

            if ($sendContactMail) {
                echo json_encode(array('status' => 'success', 'message' => 'Enquiry Send successfully'));
            } else {
                echo json_encode(array('status' => 'success', 'message' => "Error while submit the request"));
            }
        } else {
            return response()->json(['status' => 'error', 'message' => 'Error while submit the request']);
        }
    }


    public function filter_maids(Request $request)
    {
        DB::enableQueryLog();
        $condition = $this->filterCondition($request);
        $totalmaids = $condition->count();

        $maids = $condition->latest()->take(4)->get();
        $offset = $maids->count();
        $loading_limit = 8;

        return view('web.includes._maid_list', compact('maids', 'offset', 'totalmaids', 'loading_limit'));
    }


    public function filterCondition($request)
    {
        $condition = Maid::with('services', 'skill_sets')->active();;
        $inputs = [];

        if ($request->experience_year) {
            $exp_range = explode('-', $request->experience_year);
            $e1 = (int)$exp_range[0];
            $e2 = (int)$exp_range[1];
            $condition = $condition->whereBetween('experience_year', [$e1, $e2]);
        }
        if ($request->age) {
            $range = explode('-', $request->age);
            $a1 = (int)$range[0];
            $a2 = (int)$range[1];
            $condition = $condition->whereBetween('dob', [now()->subYears($a2), now()->subYears($a1)]);
        }

        if ($request->service_id) {
            $condition = $condition->whereRelation('services', function ($condition) use ($request) {
                $condition->whereIn('services.id', $request->service_id);
            });
        }

        if ($request->input_field != NULL) {
            $inputs = explode(',', $request->input_field);
            $condition = $condition->where(function ($query) use ($inputs, $request) {
                if (!empty($inputs)) {
                    foreach ($inputs as $input) {
                        if ($input == "service_id" || $input == "experience_year" || $input == "dob") {

                        } else {
                            $query->OrwhereIn($input, $request[$input]);
                        }
                    }
                }
            })->active();
        }
        return $condition;
    }


}
