<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\VisaServicePage;
use Illuminate\Http\Request;
use App\Models\VisaService;
class VisaServiceController extends Controller
{
    //


    public function visa_service()
    {
        $key = "Update";
        $title = "Visa Service Page";
        $visaservice = VisaServicePage::first();
        return view('app.visa_service.visa_service_page', compact('key', 'title', 'visaservice'));
    }

    public function visa_service_store(Request $request)
    {
//        dd($request->all());
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:225',
            'title_ar' => 'required|min:2|max:225',
            'sub_title_en' => 'min:2|max:225',
            'sub_title_ar' => 'min:2|max:225',
            'description_en' => 'required|min:2',
            'description_ar' => 'required|min:2',
//            'first_image' => 'image|mimes:jpeg,png,jpg|max:512',
//            'second_image' => 'image|mimes:jpeg,png,jpg|max:512',
            'image_attribute' => 'required',

        ]);

        if ($request->id == 0) {
            $visaservice = new VisaServicePage();
        } else {
            $visaservice = VisaServicePage::find($request->id);
            $visaservice->updated_at = now();
        }
        if ($request->hasFile('first_image')) {
            deleteFile($visaservice, 'first_image');
            deleteFile($visaservice, 'first_image_webp');
            $visaservice->first_image_webp = uploadWebpImage($request->first_image, 'uploads/visa-service/page/webp/', 'visa-service-first-image');
            $visaservice->first_image = uploadFile($request->first_image, 'uploads/visa-service/page/image/', 'visa-service-first-image');
        }
        if ($request->hasFile('second_image')) {
            deleteFile($visaservice, 'second_image');
            deleteFile($visaservice, 'second_image_webp');
            $visaservice->second_image_webp = uploadWebpImage($request->second_image, 'uploads/visa-service/page/webp/', 'visa-service-second-image');
            $visaservice->second_image = uploadFile($request->second_image, 'uploads/visa-service/page/image/', 'visa-service-second-image');
        }
        $visaservice->title_en = $request->title_en ?? '';
        $visaservice->title_ar = $request->title_ar ?? '';
        $visaservice->sub_title_en = $request->sub_title_en ?? '';
        $visaservice->sub_title_ar = $request->sub_title_ar ?? '';
        $visaservice->description_en = $request->description_en ?? '';
        $visaservice->description_ar = $request->description_ar ?? '';
        $visaservice->image_attribute = $request->image_attribute ?? '';
        if ($visaservice->save()) {
            session()->flash('success', 'Visa Service Page content has been updated successfully');
            return redirect(sitePrefix() . 'visa-service');
        } else {
            return back()->with('error', 'Error while updating the visa service page content');
        }
    }

    public function service()
    {
        $title = "Service List";
        $serviceList = VisaService::get();
        return view('app.visa_service.service.list', compact('serviceList', 'title'));
    }

    public function service_create()
    {
        $key = "Create";
        $title = "Add Visa Service";
        return view('app.visa_service.service.form', compact('key', 'title'));
    }


    public function service_store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:255',
            'title_ar' => 'required|min:2|max:255',
            'sub_title_en' => 'required|min:2|max:255',
            'sub_title_ar' => 'required|min:2|max:255',
            'description_en' => 'required',
            'description_ar' => 'required',
        ]);
        $service = new VisaService();
        $service->title_en = $validatedData['title_en'];
        $service->title_ar = $validatedData['title_ar'];
        $service->sub_title_en = $validatedData['sub_title_en'];
        $service->sub_title_ar = $validatedData['sub_title_ar'];
        $service->description_en = $request->description_en??'';
        $service->description_ar = $request->description_ar??'';
        if ($service->save()) {
            session()->flash('success', 'Visa Service "' . $request->title_en . '" has been added successfully');
            return redirect(sitePrefix().'visa-service/service');
        } else {
            return back()->with('message', 'Error while creating Visa Service');
        }
    }

    public function service_edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Visa Service Update";
        $visaservice = VisaService::find($id);
        if ($visaservice != null) {
            return view('app.visa_service.service.form', compact('key', 'visaservice', 'title'));
        } else {
            return view('app.error.404');
        }
    }


    public function service_update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:255',
            'title_ar' => 'required|min:2|max:255',
            'sub_title_en' => 'required|min:2|max:255',
            'sub_title_ar' => 'required|min:2|max:255',
            'description_en' => 'required',
            'description_ar' => 'required',
        ]);

        $service = VisaService::find($id);
        $service->title_en = $validatedData['title_en'];
        $service->title_ar = $validatedData['title_ar'];
        $service->sub_title_en = $validatedData['sub_title_en'];
        $service->sub_title_ar = $validatedData['sub_title_ar'];
        $service->description_en = $request->description_en??'';
        $service->description_ar = $request->description_ar??'';
        $service->updated_at = date('Y-m-d h:i:s');

        if ($service->save()) {
            session()->flash('success', 'Visa Service "' . $request->title_en . '" has been updated successfully');
            return redirect(sitePrefix().'visa-service/service');
        } else {
            return back()->with('message', 'Error while updating visa service');
        }
    }

    public function delete_service(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $service = VisaService::find($request->id);
            if ($service) {

                $deleted = $service->delete();
                if ($deleted == true) {
                    echo (json_encode(array('status' => true)));
                } else {
                    echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                }
            } else {
                echo (json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        }
    }

}
