<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\Maid;
use App\Models\MaidSkillSet;
use App\Models\SkillSet;
use Illuminate\Http\Request;

class SkillSetController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function skill_set()
    {
        $title = "SkillSet List";
        $skillSetList = SkillSet::latest()->get();
        $type = 'skill Sets';
        return view('app.skill_set.list', compact('skillSetList', 'title', 'type'));
    }

    public function skill_set_create()
    {
        $key = "Create";
        $title = "Create SkillSet";
        $type = "skill Sets";
        return view('app.skill_set.form', compact('key', 'title', 'type'));
    }

    public function skill_set_store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:255|unique:skill_sets,title_en,NULL,id,deleted_at,NULL',
            'title_ar' => 'required|min:2|max:255',
        ]);
        $skillSet = new SkillSet;
        $skillSet->title_en = $request->title_en ?? '';
        $skillSet->title_ar = $request->title_ar ?? '';
        if ($skillSet->save()) {
            session()->flash('success', "SkillSet '" . $skillSet->title_en . "' has been added successfully");
            return redirect(sitePrefix() . 'skill-set');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the skillSet");
        }
    }

    public function skill_set_edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Update SkillSet";
        $skillSet = SkillSet::find($id);
        if ($skillSet) {
            $type = "skill Sets";
            return view('app.skill_set.form', compact('key', 'title', 'skillSet', 'type'));
        } else {
            return view('web.error.404');
        }

    }

    public function skill_set_update(Request $request, $id)
    {
        $skillSet = SkillSet::find($id);
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:255|unique:skill_sets,title_en,' . $id . ',id,deleted_at,NULL',
            'title_ar' => 'required|min:2|max:255',
        ]);
        $skillSet->title_en = $request->title_en ?? '';
        $skillSet->title_ar = $request->title_ar ?? '';
        $skillSet->updated_at = now();
        if ($skillSet->save()) {
            session()->flash('success', "SkillSet '" . $skillSet->title_en . "' has been updated successfully");
            return redirect(sitePrefix() . 'skill-set');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the skillSet");
        }
    }

    public function skill_set_delete(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $skillSet = SkillSet::find($request->id);
            if ($skillSet) {
                $maid = MaidSkillSet::where('skill_set_id', $request->id)->count();
                if ($maid > 0) {
                    return response()->json(['status' => false, 'message' => 'Maids with Skill Set "' . $skillSet->title_en . '" exist']);
                }else{
                    if ($skillSet->delete()) {
                        echo(json_encode(array('status' => true)));
                    } else {
                        echo(json_encode(array('status' => false, 'message' => 'Some error occurred,please try after sometime')));
                    }
                }


            } else {
                echo(json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo(json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }
}
