<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\SiteInformation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SiteInformationController extends Controller
{
    //

    public function site_information()
    {
        $key = "Update";
        $title = "Site Informations";
        $siteInformation = SiteInformation::first();

        return view('app.site_information.form', compact('key', 'title', 'siteInformation'));
    }

    public function site_information_store(Request $request)
    {
        $request->validate([
            'brand_name_en' => 'required|min:2|max:255',
            'brand_name_ar' => 'required|min:2|max:255',
            'logo' => 'image|mimes:jpeg,png,jpg|max:512',
            'tadbeer_logo' => 'image|mimes:jpeg,png,jpg|max:512',
            'copyright_en' => 'required|min:2|max:255',
            'copyright_ar' => 'required|min:2|max:255',
            'logo_attribute' => 'required|min:2|max:255',
            'tadbeer_logo_attribute' => 'required|min:2|max:255',

        ]);

        if ($request->id == 0) {
            $contact = new SiteInformation();
        } else {
            $contact = SiteInformation::find($request->id);
            $contact->updated_at = date('Y-m-d h:i:s');
        }

        if ($request->hasFile('logo')) {
            if (File::exists(public_path($contact->logo))) {
                File::delete(public_path($contact->logo));
            }
            if (File::exists(public_path($contact->logo_webp))) {
                File::delete(public_path($contact->logo_webp));
            }
            $contact->logo_webp = uploadWebpImage($request->logo, 'uploads/site_information/webp_logo/', 'logo',);
            $contact->logo = uploadFile($request->logo, 'uploads/site_information/logo/', 'logo',);
        }
        if ($request->hasFile('tadbeer_logo')) {
            if (File::exists(public_path($contact->tadbeer_logo))) {
                File::delete(public_path($contact->tadbeer_logo));
            }
            if (File::exists(public_path($contact->tadbeer_logo_webp))) {
                File::delete(public_path($contact->tadbeer_logo_webp));
            }
            $contact->tadbeer_logo_webp = uploadWebpImage($request->tadbeer_logo, 'uploads/site_information/tadbeer_logo_webp/', 'tadbeer_logo');
            $contact->tadbeer_logo = uploadFile($request->tadbeer_logo, 'uploads/site_information/tadbeer_logo/', 'tadbeer_logo');
        }

        $contact->brand_name_en = $request->brand_name_en ?? '';
        $contact->brand_name_ar = $request->brand_name_ar ?? '';

        $contact->logo_attribute = $request->logo_attribute ?? '';
        $contact->tadbeer_logo_attribute = $request->tadbeer_logo_attribute ?? '';
        $contact->copyright_en = $request->copyright_en ?? '';
        $contact->copyright_ar = $request->copyright_ar ?? '';
        $contact->privacy_policy_en = $request->privacy_policy_en ?? '';
        $contact->privacy_policy_ar = $request->privacy_policy_ar ?? '';
        $contact->terms_and_conditions_en = $request->terms_and_conditions_en ?? '';
        $contact->terms_and_conditions_ar = $request->terms_and_conditions_ar ?? '';


        if ($contact->save()) {
            session()->flash('success', 'Site information has been updated successfully');
            return redirect(sitePrefix() . 'site-information');
        } else {
            return back()->with('error', 'Error while updating the site information');
        }
    }

    public function other_meta_tag()
    {
        $key = "Update";
        $title = "Update Extra Tags";
        $tag = SiteInformation::first();
        return view('app.tags.extra_tag_form', compact('key', 'title', 'tag'));
    }

    public function other_meta_tag_store(Request $request)
    {
        $validatedData = $request->validate([
            'header_tag' => 'required|min:2',
        ]);
        if ($request->id == 0) {
            $tag = new SiteInformation;
        } else {
            $tag = SiteInformation::find($request->id);
            $tag->updated_at = date('Y-m-d h:i:s');
        }
        $tag->header_tag = $validatedData['header_tag'];
        $tag->footer_tag = isset($request->footer_tag) ? $request->footer_tag : '';
        $tag->body_tag = isset($request->body_tag) ? $request->body_tag : '';
        if ($tag->save()) {
            session()->flash('success', 'Tag content has been updated successfully');
            return redirect(sitePrefix() . 'other-meta-tag/');
        } else {
            return back()->with('message', 'Error while updating the tag content');
        }
    }

}
