<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Department;
use App\Models\Designation;
use DB;

class MasterController extends Controller
{

    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function department(){
        $title="Department List";
        $department_list=Department::get();
        return view('app.master.department.list',compact('title','department_list'));
    }

    public function department_create(){
        $key="Create";
        $title="Create Department";
        return view('app.master.department.form',compact('key','title',));
    }


    public function department_store(Request $request){
        DB::beginTransaction();
        $valid = $third_valid = true;
        $validatedData = $request->validate([
            'title' => 'required|min:2|max:230',
        ]);
            $department = new Department;
            $department->title = $validatedData['title'];
            $sort_order = Department::orderBy('sort_order', 'DESC')->first();
            if ($sort_order) {
                $sort_number = ($sort_order->sort_order + 1);
            } else {
                $sort_number = 1;
            }
            $department->sort_order = $sort_number;
            if($department->save()){
                session()->flash('success', "Department '".$department->question."' has been added successfully");
                DB::commit();
                return redirect(sitePrefix().'master/department');
            }else{
                DB::rollBack();
                return back()->withInput($request->input())->withErrors("Error while updating the Department");
            }
    }

    public function department_edit(Request $request,$id){
        $key="Update";
        $title="Update Department";
        $department=Department::find($id);
        if($department){
            return view('app.master.department.form',compact('key','title','department'));
        }else{
            return view('app.error.404');
        }

    }

    public function department_update(Request $request,$id){
        DB::beginTransaction();
            $department =  Department::find($id);
            $valid = $second_valid = true;
            $validatedData = $request->validate([
                'title' => 'required|min:2|max:230',
            ]);
            $department->title = $validatedData['title'];
            $department->updated_at = date('Y-m-d h:i:s');
            if($department->save()){
                session()->flash('success', "Department '".$department->title."' has been updated successfully");
                DB::commit();
                return redirect(sitePrefix().'master/department');
            }else{
                DB::rollBack();
                return back()->withInput($request->input())->withErrors("Error while updating the Departmenr");
            }

    }

    public function delete_department(Request $request){
        if (isset($request->id) && $request->id != null) {
            $department = Department::find($request->id);
            if ($department) {

                $deleted = $department->delete();
                if ($deleted == true) {
                    echo (json_encode(array('status' => true)));
                } else {
                    echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                }
            } else {
                echo (json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo (json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }

    public function designation(){
        $title="Designation List";
        $designation_list=Designation::get();
        return view('app.master.designation.list',compact('title','designation_list'));
    }

    public function designation_create(){
        $key="Create";
        $title="Create Designation";
        return view('app.master.designation.form',compact('key','title',));
    }

    public function designation_store(Request $request){
        DB::beginTransaction();
        $valid = $third_valid = true;
        $validatedData = $request->validate([
            'title' => 'required|min:2|max:230',
        ]);
            $designation = new Designation;
            $designation->title = $validatedData['title'];

            if($designation->save()){
                session()->flash('success', "Designation '".$designation->designation."' has been added successfully");
                DB::commit();
                return redirect(sitePrefix().'master/designation');
            }else{
                DB::rollBack();
                return back()->withInput($request->input())->withErrors("Error while updating the Designation");
            }
    }

    public function designation_edit(Request $request,$id){
        $key="Update";
        $title="Update Designation";
        $designation=Designation::find($id);
        if($designation){
            return view('app.master.designation.form',compact('key','title','designation'));
        }else{
            return view('app.error.404');
        }

    }

    public function designation_update(Request $request,$id){
        DB::beginTransaction();
            $designation =  Designation::find($id);
            $valid = $second_valid = true;
            $validatedData = $request->validate([
                'title' => 'required|min:2|max:230',
            ]);
            $designation->title = $validatedData['title'];
            $designation->updated_at = date('Y-m-d h:i:s');
            if($designation->save()){
                session()->flash('success', "Designation '".$designation->title."' has been updated successfully");
                DB::commit();
                return redirect(sitePrefix().'master/designation');
            }else{
                DB::rollBack();
                return back()->withInput($request->input())->withErrors("Error while updating the Designation");
            }

    }
}
