<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use App\Models\ContactAddress;
use App\Models\ContactFormRequest;
use App\Models\EnquiryForm;
use App\Models\HomeContactUs;
use App\Models\PartnersAddress;
use App\Models\SiteInformation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ContactController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function home_contact_us()
    {
        $key = "Update";
        $title = "Contact Us";
        $contact = HomeContactUs::first();
        return view('app.home.home_contact_us_form',compact('key','title','contact'));
    }

    public function home_contact_us_store(Request $request)
    {
        if($request->id==0){
            $contact = new HomeContactUs;
        }else{
            $contact = HomeContactUs::find($request->id);
            $contact->updated_at = date('Y-m-d h:i:s');
        }
//        if ($request->hasFile('image')) {
//            if (File::exists($contact->image)) {
//                File::delete($contact->image);
//            }
//            $contact->image = uploadFile($request->image, 'contact-us', 'uploads/home_contact_us/image/');
//        }
//        if ($request->hasFile('webp_image')) {
//            if (File::exists($contact->webp_image)) {
//                File::delete($contact->webp_image);
//            }
//            $contact->webp_image = uploadFile($request->webp_image, 'contact-us', 'uploads/home_contact_us/webp_image/');
//        }
        $contact->title = $request->title ?? '';
        $contact->sub_title = $request->sub_title ?? '';
        $contact->second_title = $request->second_title ?? '';
        $contact->description = $request->description ?? '';
//        $contact->image_attribute = $request->image_attribute ?? '';
        $contact->button_text = $request->button_text ?? '';
        $contact->button_url = $request->button_url ?? '';
        if($contact->save()){
            session()->flash('success', 'Home-Contact Us content has been updated successfully');
            return redirect(sitePrefix().'home/contact-us');
        }else{
            return back()->with('error', 'Error while updating the home-contact content');
        }
    }

    public function contact_list()
    {
        $title = "Contact List";
        $contactList = EnquiryForm::where('type','main_enquiry')->orderBy('id', 'desc')->get();
        return view('app.contact_us.contact_list', compact('contactList', 'title'));

    }

    public function contact_view($id)
    {
        $title = "View Request";
        $contact = EnquiryForm::find($id);
        return view('app.contact_us.contact_view', compact('contact', 'title'));

    }

    public function reply_to_contact(Request $request)
    {
        if (isset($request->replay) && $request->replay != null) {
            $contact = EnquiryForm::find($request->id);
            if ($contact) {
                DB::beginTransaction();
                $contact->reply = $request->replay;
                $contact->reply_date = date('Y-m-d h:i:s');
                if ($contact->save()) {
                    if (SendContactReply($contact)) {
                        DB::commit();
                        echo (json_encode(array('status' => true, 'message' => 'Replay saved successfully')));
                    } else {
                        DB::rollBack();
                        echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                    }
                } else {
                    DB::rollBack();
                    echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                }
            } else {
                echo (json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo (json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }

    public function delete_contact(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $contact = EnquiryForm::find($request->id);
            if ($contact) {
                $deleted = $contact->delete();
                if ($deleted == true) {
                    echo (json_encode(array('status' => true)));
                } else {
                    echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                }
            } else {
                echo (json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo (json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }

    public function delete_multi_contact(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $contactArray = explode(',', $request->id);
            $successArray = array();
            foreach ($contactArray as $con) {
                $contact = EnquiryForm::find($con);
                $deleted = $contact->delete();
                if ($deleted == true) {
                    $successArray[] = '1';
                }
            }
            if ($successArray) {
                echo (json_encode(array('status' => true)));
            }
        } else {
            echo (json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }

    public function contact()
    {
        $key = "Update";
        $title = "Contact Page";
        $contact = SiteInformation::first();
        return view('app.contact_us.contact_form',compact('key','title','contact'));
    }

    public function contact_store(Request $request)
    {
//        dd($request->all());
        $validatedData = $request->validate([
//            'contact_request_title_en' => 'required|min:2|max:255',
//            'contact_request_title_ar' => 'required|min:2|max:255',
            'location_en' => 'nullable|min:2',
            'location_ar' => 'nullable|min:2',
            'working_time_en' => 'nullable|min:2',
            'working_time_ar' => 'nullable|min:2',
            'phone' => 'nullable|regex:/^([0-9\+]*)$/|min:7|max:17',
            'alternate_phone' => 'nullable|regex:/^([0-9\+]*)$/|min:7|max:17',
            'whatsapp_number' => 'nullable|regex:/^([0-9\+]*)$/|min:7|max:17',
            'email' => 'required|email',
            'alternate_email_id' => 'nullable|email',
            'email_recipient' => 'required|min:2|max:255',
        ]);

        if($request->id==0){
            $contact = new SiteInformation();
        } else {
            $contact = SiteInformation::find($request->id);
            $contact->updated_at = date('Y-m-d h:i:s');
        }

        $contact->contact_request_title_en = $request->contact_request_title_en ?? '';
        $contact->contact_request_title_ar = $request->contact_request_title_ar ?? '';
        $contact->location_en = $request->location_en ?? '';
        $contact->location_ar = $request->location_ar ?? '';
        $contact->footer_location_en = $request->footer_location_en ?? '';
        $contact->footer_location_ar = $request->footer_location_ar ?? '';
        $contact->working_hours_en = $request->working_time_en ?? '';
        $contact->working_hours_ar = $request->working_time_ar ?? '';
        $contact->phone = $request->phone ?? '';
        $contact->alternate_phone = $request->alternate_phone ?? '';
        $contact->whatsapp_number = $request->whatsapp_number ?? '';
        $contact->email = $request->email ?? '';
        $contact->alternate_email = $request->alternate_email ?? '';
        $contact->email_recipient = $request->email_recipient ?? '';
        $contact->facebook_url = $request->facebook_url ?? '';
        $contact->instagram_url = $request->instagram_url ?? '';
        $contact->twitter_url = $request->twitter_url??'';
        $contact->linkedin_url = $request->linkedin_url??'';
        $contact->youtube_url = $request->youtube_url??'';
        $contact->pinterest_url = $request->pinterest_url??'';
        $contact->snapchat_url = $request->snapchat_url??'';
        $contact->google_map = ($request->google_map)?$request->google_map:'';

        if($contact->save()){
            session()->flash('success', 'Contact page details has been updated successfully');
            return redirect(sitePrefix().'contact');
        }else{
            return back()->with('error', 'Error while updating the contact page details');
        }
    }





}
