<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\BlogDetailsPageHeading;
use App\Models\BlogListPageHeading;
use App\Models\HomeHeading;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class BlogController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function list()
    {
        $title = "Blog List";
        $blogList = Blog::get();
        $home_heading = HomeHeading::type('blog')->first();

        return view('app.blog.list', compact('blogList', 'title','home_heading'));
    }

    public function create()
    {
        $key = "Create";
        $title = "Add Blog";
        return view('app.blog.form', compact('key', 'title'));
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:230',
            'title_ar' => 'required|min:2|max:230',
            'sub_title_en' => 'required|min:2|max:230',
            'sub_title_ar' => 'required|min:2|max:230',
            'short_url'=>'required|min:2|max:230|unique:blogs,short_url,NULL,id,deleted_at,NULL',
            'list_description_en' => 'required',
            'list_description_ar' => 'required',
            'description_en' => 'required',
            'description_ar' => 'required',
            'posted_date' => 'required',
            'banner_title_en'=>'nullable|min:2|max:230',
            'banner_title_ar'=>'nullable|min:2|max:230',
            'meta_title'=>'nullable|min:2|max:255',
            'written_by_en'=>'nullable|min:2|max:60',
            'written_by_ar'=>'nullable|min:2|max:60',


//            'image' => 'image|mimes:jpeg,png,jpg|max:512',
//            'video_thumbnail_image' => 'image|mimes:jpeg,png,jpg|max:512',
//            'banner_image' => 'image|mimes:jpeg,png,jpg|max:512',
        ]);

        $blog = new Blog;
        if ($request->hasFile('image')) {
            $blog->webp_image = uploadWebpImage($request->image, 'uploads/blog/webp_image/', $request->title_en);
            $blog->image = uploadFile($request->image, 'uploads/blog/image/', $request->title_en);
        }
        if ($request->hasFile('video_thumbnail_image')) {
            $blog->video_thumbnail_webp_image = uploadWebpImage($request->video_thumbnail_image, 'uploads/blog/video_thumbnail_webp_image/', $request->title_en);
            $blog->video_thumbnail_image = uploadFile($request->video_thumbnail_image, 'uploads/blog/video_thumbnail_image/', $request->title_en);
        }
        if ($request->hasFile('banner_image')) {
            $blog->banner_webp_image = uploadWebpImage($request->banner_image, 'uploads/blog/banner_webp/', $request->title_en);
            $blog->banner_image = uploadFile($request->banner_image, 'uploads/blog/banner/', $request->title_en);
        }


        $blog->title_en = $validatedData['title_en'];
        $blog->title_ar = $validatedData['title_ar'];
        $blog->sub_title_en = $validatedData['sub_title_en'];
        $blog->sub_title_ar = $validatedData['sub_title_ar'];
        $blog->short_url = $validatedData['short_url'];
        $blog->image_meta_tag = $request->image_meta_tag??'';
        $blog->posted_date = $validatedData['posted_date'];
        $blog->written_by_en = $validatedData['written_by_en'];
        $blog->written_by_ar = $validatedData['written_by_ar'];
        $blog->list_description_en = $request->list_description_en??'';
        $blog->list_description_ar = $request->list_description_ar??'';
        $blog->description_en = $request->description_en??'';
        $blog->description_ar = $request->description_ar??'';
        $blog->video_url = $request->video_url?? '';
        $blog->video_meta_tag = $request->video_meta_tag??'';
        $blog->alternate_description_en = $request->alternate_description_en ?? '';
        $blog->alternate_description_ar = $request->alternate_description_ar ?? '';
        $blog->banner_title_en = $request->banner_title_en??'';
        $blog->banner_title_ar = $request->banner_title_ar ?? '';
        $blog->banner_attribute = $request->banner_attribute??'';
        $blog->meta_title = ($request->meta_title) ? $request->meta_title : '';
        $blog->meta_description = ($request->meta_description) ? $request->meta_description : '';
        $blog->meta_keyword = ($request->meta_keyword) ? $request->meta_keyword : '';
        $blog->other_meta_tag = ($request->other_meta_tag) ? $request->other_meta_tag : '';

        if ($blog->save()) {
            session()->flash('success', 'Blog "' . $request->title . '" has been added successfully');
            return redirect(sitePrefix().'blog/');
        } else {
            return back()->with('message', 'Error while creating blog');
        }
    }

    public function edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Blog Update";
        $blog = Blog::find($id);
        if ($blog != null) {
            return view('app.blog.form', compact('key', 'blog', 'title'));
        } else {
            return view('app.error.404');
        }
    }

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:255',
            'title_ar' => 'required|min:2|max:255',
            'sub_title_en' => 'required|min:2|max:255',
            'sub_title_ar' => 'required|min:2|max:255',
            'short_url'=>'required|min:2|max:255|unique:blogs,short_url,' . $id . ',id,deleted_at,NULL',
            'list_description_en' => 'required',
            'list_description_ar' => 'required',
            'description_en' => 'required',
            'description_ar' => 'required',
            'posted_date' => 'required',
            'banner_title_en'=>'nullable|min:2|max:255',
            'banner_title_ar'=>'nullable|min:2|max:255',
            'meta_title'=>'nullable|min:2|max:255',
            'written_by_en'=>'nullable|min:2|max:60',
            'written_by_ar'=>'nullable|min:2|max:60',


//            'image' => 'image|mimes:jpeg,png,jpg|max:512',
//            'video_thumbnail_image' => 'image|mimes:jpeg,png,jpg|max:512',
//            'banner_image' => 'image|mimes:jpeg,png,jpg|max:512',
        ]);

        $blog = Blog::find($id);

        if ($request->hasFile('image')) {
            if (File::exists(public_path($blog->image))) {
                File::delete(public_path($blog->image));
            }
            if (File::exists(public_path($blog->webp_image))) {
                File::delete(public_path($blog->webp_image));
            }
            $blog->webp_image = uploadWebpImage($request->image, 'uploads/blog/webp_image/',$request->title_en);
            $blog->image = uploadFile($request->image, 'uploads/blog/image/',$request->title_en);
        }
        if ($request->hasFile('video_thumbnail_image')) {
            if (File::exists(public_path($blog->video_thumbnail_image))) {
                File::delete(public_path($blog->video_thumbnail_image));
            }
            if (File::exists(public_path($blog->video_thumbnail_webp_image))) {
                File::delete(public_path($blog->video_thumbnail_webp_image));
            }
            $blog->video_thumbnail_webp_image = uploadWebpImage($request->video_thumbnail_image,  'uploads/blog/video_thumbnail_webp_image/',$request->title_en);
            $blog->video_thumbnail_image = uploadFile($request->video_thumbnail_image,  'uploads/blog/video_thumbnail_image/',$request->title_en);
        }
        if ($request->hasFile('banner_image')) {
            if (File::exists(public_path($blog->banner_image))) {
                File::delete(public_path($blog->banner_image));
            }
            $blog->banner_webp_image = uploadWebpImage($request->banner_image,  'uploads/blog/banner_webp/',$request->title_en);
            $blog->banner_image = uploadFile($request->banner_image,  'uploads/blog/banner/',$request->title_en);
        }

        $blog->title_en = $validatedData['title_en'];
        $blog->title_ar = $validatedData['title_ar'];
        $blog->sub_title_en = $validatedData['sub_title_en'];
        $blog->sub_title_ar = $validatedData['sub_title_ar'];
        $blog->short_url = $validatedData['short_url'];
        $blog->image_meta_tag = $request->image_meta_tag??'';
        $blog->posted_date = $validatedData['posted_date'];
        $blog->written_by_en = $validatedData['written_by_en'];
        $blog->written_by_ar = $validatedData['written_by_ar'];
        $blog->list_description_en = $request->list_description_en??'';
        $blog->list_description_ar = $request->list_description_ar??'';
        $blog->description_en = $request->description_en??'';
        $blog->description_ar = $request->description_ar??'';
        $blog->video_url = $request->video_url?? '';
        $blog->video_meta_tag = $request->video_meta_tag??'';
        $blog->alternate_description_en = $request->alternate_description_en ?? '';
        $blog->alternate_description_ar = $request->alternate_description_ar ?? '';
        $blog->banner_title_en = $request->banner_title_en??'';
        $blog->banner_title_ar = $request->banner_title_ar ?? '';
        $blog->banner_attribute = $request->banner_attribute??'';
        $blog->meta_title = ($request->meta_title) ? $request->meta_title : '';
        $blog->meta_description = ($request->meta_description) ? $request->meta_description : '';
        $blog->meta_keyword = ($request->meta_keyword) ? $request->meta_keyword : '';
        $blog->other_meta_tag = ($request->other_meta_tag) ? $request->other_meta_tag : '';
        $blog->updated_at = date('Y-m-d h:i:s');

        if ($blog->save()) {
            session()->flash('success', 'Blog "' . $request->title . '" has been updated successfully');
            return redirect(sitePrefix().'blog/');
        } else {
            return back()->with('message', 'Error while updating blog');
        }
    }

    public function delete(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $blog = Blog::find($request->id);
            if ($blog) {
                if (File::exists(public_path($blog->image))) {
                    File::delete(public_path($blog->image));
                }
                if (File::exists(public_path($blog->webp_image))) {
                    File::delete(public_path($blog->webp_image));
                }
                if (File::exists(public_path($blog->video_thumbnail_image))) {
                    File::delete(public_path($blog->video_thumbnail_image));
                }
                if (File::exists(public_path($blog->video_thumbnail_webp_image))) {
                    File::delete(public_path($blog->video_thumbnail_webp_image));
                }
                if (File::exists(public_path($blog->banner_image))) {
                    File::delete(public_path($blog->banner_image));
                }
                if (File::exists(public_path($blog->banner_webp_image))) {
                    File::delete(public_path($blog->banner_webp_image));
                }
                $deleted = $blog->delete();
                if ($deleted == true) {
                    echo (json_encode(array('status' => true)));
                } else {
                    echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                }
            } else {
                echo (json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        }
    }

}
