<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\AboutBoxContent;
use App\Models\AboutUs;
use App\Models\HomeAboutUs;
use App\Models\Partner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class AboutController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function home_about_us()
    {
        $key = "Update";
        $title = "About";
        $about = HomeAboutUs::first();
        return view('app.home.home_about_us_form', compact('key', 'title', 'about'));
    }

    public function home_about_us_store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:225',
            'title_ar' => 'required|min:2|max:225',
            'description_en' => 'required|min:2',
            'description_ar' => 'required|min:2',
            'first_image' => 'image|mimes:jpeg,png,jpg|max:512',
            'second_image' => 'image|mimes:jpeg,png,jpg|max:512',
            'image_attribute' => 'required|min:5',
            'button_text_en' => 'required|min:2',
            'button_text_ar' => 'required|min:2',
            'button_url' => 'required|min:2',
        ]);

        if ($request->id == 0) {
            $about = new HomeAboutUs;
        } else {
            $about = HomeAboutUs::find($request->id);
            $about->updated_at = now();
        }
        if ($request->hasFile('first_image')) {
            deleteFile($about, 'first_image');
            deleteFile($about, 'first_image_webp');
            $about->first_image_webp = uploadWebpImage($request->first_image, 'uploads/home/about_us/image/webp/', 'about-us-first-image');
            $about->first_image = uploadFile($request->first_image, 'uploads/home/about_us/image/', 'about-us-first-image');
        }
        if ($request->hasFile('second_image')) {
            deleteFile($about, 'second_image');
            deleteFile($about, 'second_image_webp');
            $about->second_image_webp = uploadWebpImage($request->second_image, 'uploads/home/about_us/image/webp/', 'about-us-second-image');
            $about->second_image = uploadFile($request->second_image, 'uploads/home/about_us/image/', 'about-us-second-image');
        }

        $about->title_en = $request->title_en ?? '';
        $about->title_ar = $request->title_ar ?? '';
        $about->sub_title_en = $request->sub_title_en ?? '';
        $about->sub_title_ar = $request->sub_title_ar ?? '';
        $about->description_en = $request->description_en ?? '';
        $about->description_ar = $request->description_ar ?? '';
        $about->image_attribute = $request->image_attribute ?? '';
        $about->button_text_en = $request->button_text_en ?? '';
        $about->button_text_ar = $request->button_text_ar ?? '';
        $about->button_url = $request->button_url ?? '';
        if ($about->save()) {
            session()->flash('success', 'Home-About content has been updated successfully');
            return redirect(sitePrefix() . 'home/about-us');
        } else {
            return back()->with('error', 'Error while updating the home-about content');
        }
    }


    public function about_us()
    {
        $key = "Update";
        $title = "About";
        $about = AboutUs::first();
        return view('app.about.about_us_form', compact('key', 'title', 'about'));
    }

    public function about_us_store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:225',
            'title_ar' => 'required|min:2|max:225',
            'sub_title_en' => 'min:2|max:225',
            'sub_title_ar' => 'min:2|max:225',
            'description_en' => 'required|min:2',
            'description_ar' => 'required|min:2',
            'first_image' => 'image|mimes:jpeg,png,jpg|max:512',
            'second_image' => 'image|mimes:jpeg,png,jpg|max:512',
            'image_attribute' => 'required',
            'mission_image' => 'image|mimes:jpeg,png,jpg,svg|max:512',
            'vision_image' => 'image|mimes:jpeg,png,jpg,svg|max:512',
        ]);

        if ($request->id == 0) {
            $about = new AboutUs;
        } else {
            $about = AboutUs::find($request->id);
            $about->updated_at = now();
        }
        if ($request->hasFile('first_image')) {
            deleteFile($about, 'first_image');
            deleteFile($about, 'first_image_webp');
            $about->first_image_webp = uploadWebpImage($request->first_image, 'uploads/about_us/image/webp/', 'about-us-first-image');
            $about->first_image = uploadFile($request->first_image, 'uploads/about_us/image/', 'about-us-first-image');
        }
        if ($request->hasFile('second_image')) {
            deleteFile($about, 'second_image');
            deleteFile($about, 'second_image_webp');
            $about->second_image_webp = uploadWebpImage($request->second_image, 'uploads/about_us/image/webp/', 'about-us-second-image');
            $about->second_image = uploadFile($request->second_image, 'uploads/about_us/image/', 'about-us-second-image');
        }
        if ($request->hasFile('mission_image')) {
            deleteFile($about, 'mission_image');
            deleteFile($about, 'mission_image_webp');
            $about->mission_image_webp = uploadWebpImage($request->mission_image, 'uploads/about_us/image/webp/', 'about-us-mission-image');
            $about->mission_image = uploadFile($request->mission_image, 'uploads/about_us/image/', 'about-us-mission-image');
        }
        if ($request->hasFile('vision_image')) {
            deleteFile($about, 'vision_image');
            deleteFile($about, 'vision_image_webp');
            $about->vision_image_webp = uploadWebpImage($request->vision_image, 'uploads/about_us/image/webp/', 'about-us-vision-image');
            $about->vision_image = uploadFile($request->vision_image, 'uploads/about_us/image/', 'about-us-vision-image');
        }

        $about->title_en = $request->title_en ?? '';
        $about->title_ar = $request->title_ar ?? '';
        $about->sub_title_en = $request->sub_title_en ?? '';
        $about->sub_title_ar = $request->sub_title_ar ?? '';
        $about->description_en = $request->description_en ?? '';
        $about->description_ar = $request->description_ar ?? '';
        $about->alternate_description_en = $request->alternate_description_en ?? '';
        $about->alternate_description_ar = $request->alternate_description_ar ?? '';

        $about->image_attribute = $request->image_attribute ?? '';
        $about->image_title_en = $request->image_title_en ?? '';
        $about->image_title_ar = $request->image_title_ar ?? '';
        $about->image_sub_title_en = $request->image_sub_title_en ?? '';
        $about->image_sub_title_ar = $request->image_sub_title_ar ?? '';

        $about->alternate_title_en = $request->alternate_title_en ?? '';
        $about->alternate_title_ar = $request->alternate_title_ar ?? '';
        $about->alternate_sub_title_en = $request->alternate_sub_title_en ?? '';
        $about->alternate_sub_title_ar = $request->alternate_sub_title_ar ?? '';
        $about->second_alternate_description_en = $request->second_alternate_description_en ?? '';
        $about->second_alternate_description_ar = $request->second_alternate_description_ar ?? '';
        $about->button_text_en = $request->button_text_en ?? '';
        $about->button_text_ar = $request->button_text_ar ?? '';
        $about->button_url = $request->button_url ?? '';

        $about->mission_title_en = $request->mission_title_en ?? '';
        $about->mission_title_ar = $request->mission_title_ar ?? '';
        $about->mission_sub_title_en = $request->mission_sub_title_en ?? '';
        $about->mission_sub_title_ar = $request->mission_sub_title_ar ?? '';
        $about->mission_description_en = $request->mission_description_en ?? '';
        $about->mission_description_ar = $request->mission_description_ar ?? '';
        $about->mission_image_attribute = $request->mission_image_attribute ?? '';

        $about->vision_title_en = $request->vision_title_en ?? '';
        $about->vision_title_ar = $request->vision_title_ar ?? '';
        $about->vision_sub_title_en = $request->vision_sub_title_en ?? '';
        $about->vision_sub_title_ar = $request->vision_sub_title_ar ?? '';
        $about->vision_description_en = $request->vision_description_en ?? '';
        $about->vision_description_ar = $request->vision_description_ar ?? '';
        $about->vision_image_attribute = $request->vision_image_attribute ?? '';

        if ($about->save()) {
            session()->flash('success', 'About content has been updated successfully');
            return redirect(sitePrefix() . 'about-us');
        } else {
            return back()->with('error', 'Error while updating the about content');
        }
    }
}
