<?php

use App\Models\Maid;
use App\Models\SiteInformation;
use App\Models\Admin;
use App\Models\Category;
use App\Models\Contact;
use Buglinjo\LaravelWebp\Facades\Webp;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\File;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;


if (!function_exists('loggedUserName')) {
    function loggedUserName()
    {
        $logged = Auth::guard('admin')->user();
        if ($logged) {
            $user = Admin::find($logged->user_id);
            if ($user) {
                return $user->name;
            }
        }
    }
}

if (!function_exists('loggedUserProfileImage')) {
    function loggedUserProfileImage()
    {
        $logged = Auth::guard('admin')->user();
        $image = asset('app/dist/img/user-default.png');
        if ($logged && $logged->profile_image != NULL) {
            $image = asset($logged->profile_image);
        }
        return $image;
    }
}

if (!function_exists('sitePrefix')) {
    function sitePrefix()
    {
        return strtolower('dashboard/');
    }
}

if (!function_exists('mailConf')) {
    function mailConf($subject)
    {
        require base_path("vendor/autoload.php");
        $mail = new PHPMailer(true);
//        $mail->isSMTP();
        $mail->CharSet = 'utf-8';
//        $mail->SMTPAuth = true;
        // $mail->SMTPDebug  = 2;
        $mail->SMTPSecure = env('MAIL_ENCRYPTION');
        $mail->Host = env('MAIL_HOST');  //gmail has host > smtp.gmail.com
        $mail->Port = env('MAIL_PORT'); //gmail has port > 587 . without double quotes
        $mail->Username = env('MAIL_USERNAME'); //your username. actually your email
        $mail->Password = env('MAIL_PASSWORD'); // your password. your mail password
        $mail->setFrom(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
        // $mail->SetFrom = (env('MAIL_FROM_ADDRESS'));
        $mail->Subject = $subject;
        $mail->IsHTML(true);
        return $mail;
    }
}

if (!function_exists('SendContactMail')) {

    function SendContactMail($contact)
    {
        if($contact->maid_id || $contact->visa_service_id){
            $subject = ($contact->subject != NULL) ? $contact->subject : ' Booking';

        }else{
            $subject = ($contact->subject != NULL) ? $contact->subject : ' Enquiry';

        }
        $siteInfo = SiteInformation::first();
        $subject = config('app.name') . ' - ' . $subject;
        $mail = mailConf($subject);

        if($contact->maid_id){
            $searchArr = ["{name}", "{email_id}", "{phone}","{maid}", "{message}", "{site_name}"];
            $replaceArr = [$contact->name, $contact->email, $contact->phone,$contact->maid->name_en, $contact->message, config('app.name')];
            $body = file_get_contents(resource_path('views/mail_template/book_maid.blade.php'));

        }elseif($contact->visa_service_id){
            $searchArr = ["{name}", "{email_id}", "{phone}","{visa_service}", "{message}", "{site_name}"];
            $replaceArr = [$contact->name, $contact->email, $contact->phone,$contact->visa_service->title_en, $contact->message, config('app.name')];
            $body = file_get_contents(resource_path('views/mail_template/book_visa_service.blade.php'));

        }else{
            $searchArr = ["{name}", "{email_id}", "{phone}", "{message}", "{site_name}"];
            $replaceArr = [$contact->name, $contact->email, $contact->phone, $contact->message, config('app.name')];
            $body = file_get_contents(resource_path('views/mail_template/contact_enquiry.blade.php'));

        }


        $body = str_replace($searchArr, $replaceArr, $body);
        $mail->MsgHTML($body);
        $mail->addAddress($siteInfo->email, $siteInfo->email_recepient);
        $mail->send();
        if ($mail) {
            return true;
        } else {
            return false;
        }
    }
}



if (!function_exists('SendServiceEnquirytMail')) {

    function SendServiceEnquirytMail($contact)
    {
        $subject = ($contact->subject != NULL) ? $contact->subject : ' Enquiry';
        $siteInfo = SiteInformation::first();
        $subject = config('app.name') . ' - ' . $subject;
        $mail = mailConf($subject);
        $enqservices='';
        foreach ($contact->services as $service){
            $enqservices.=$service->title_en.',';
        }

            $searchArr = ["{name}", "{email_id}", "{phone}", "{service}","{message}", "{site_name}"];
            $replaceArr = [$contact->name, $contact->email, $contact->phone,$enqservices, $contact->message, config('app.name')];
            $body = file_get_contents(resource_path('views/mail_template/service_enquiry.blade.php'));

        $body = str_replace($searchArr, $replaceArr, $body);
        $mail->MsgHTML($body);
        $mail->addAddress($siteInfo->email, $siteInfo->email_recepient);
        $mail->send();
        if ($mail) {
            return true;
        } else {
            return false;
        }
    }
}





if (!function_exists('SendContactReply')) {

    function SendContactReply($enquiry)
    {
        $subject = ($enquiry->subject != NULL) ? $enquiry->subject : config('app.name') . ' - Contact Enquiry Reply';
        $mail = mailConf($subject);
        $searchArr = ["{name}", "{message}", "{reply}", "{site_name}"];
        $replaceArr = [$enquiry->name, $enquiry->message, $enquiry->reply, config('app.name')];
        $body = file_get_contents(resource_path('views/mail_template/contact_enquiry_reply.blade.php'));
        $body = str_replace($searchArr, $replaceArr, $body);
        $mail->MsgHTML($body);
        $mail->addAddress($enquiry->email, $enquiry->name);
        $mail->send();
        if ($mail) {
            return true;
        } else {
            return false;
        }
    }
}

if (!function_exists('SendServiceEnquiryMail')) {

    function SendServiceEnquiryMail($enquiry)
    {
        $subject = ($enquiry->subject != NULL) ? $enquiry->subject : 'Request More Info';
        $siteInfo = Contact::first();
        $subject = config('app.name') . ' - ' . $subject;
        $mail = mailConf($subject);
        if ($enquiry->service_id != NULL) {
            $searchArr = ["{name}", "{email_id}", "{phone}", "{service}", "{company}", "{message}", "{site_name}"];
            $replaceArr = [$enquiry->name, $enquiry->email, $enquiry->phone, $enquiry->service->title, $enquiry->company, $enquiry->message, config('app.name')];
            $body = file_get_contents(resource_path('views/mail_template/service_enquiry.blade.php'));
        } else {
            $searchArr = ["{name}", "{email_id}", "{phone}", "{message}", "{site_name}"];
            $replaceArr = [$enquiry->name, $enquiry->email, $enquiry->phone, $enquiry->message, config('app.name')];
            $body = file_get_contents(resource_path('views/mail_template/contact_enquiry.blade.php'));
        }
        $body = str_replace($searchArr, $replaceArr, $body);
        $mail->MsgHTML($body);
        $mail->addAddress($siteInfo->email_id, $siteInfo->email_recepient);
        if ($mail->send()) {
            return true;
        } else {
            return false;
        }
    }
}

if (!function_exists('sendServiceEnquiryReply')) {

    function sendServiceEnquiryReply($enquiry)
    {
        $subject = ($enquiry->subject != NULL) ? $enquiry->subject : 'Request More Info';
        $subject = config('app.name') . ' - Request More Info Reply';
        $mail = mailConf($subject);
        $searchArr = ["{name}", "{service}", "{message}", "{reply}", "{site_name}"];
        $replaceArr = [$enquiry->name, ($enquiry->service != 0) ? $enquiry->service->title : '', $enquiry->message, $enquiry->reply, config('app.name')];
        $body = file_get_contents(resource_path('views/mail_template/service_enquiry_reply.blade.php'));
        $body = str_replace($searchArr, $replaceArr, $body);
        $mail->MsgHTML($body);
        $mail->addAddress($enquiry->email, $enquiry->name);
        $mail->send();
        if ($mail) {
            return true;
        } else {
            return false;
        }
    }
}

if (!function_exists('ForgotMail')) {
    function ForgotMail($contact)
    {
        $subject = config('app.name') . ' - Reset Password Notification';
        $link = url('/'.sitePrefix().'reset-password/' . $contact->token);
        $mail = mailConf($subject);
        $searchArr = ["{name}", "{link}", "{site_name}"];
        $replaceArr = [$contact->name, $link, config('app.name')];
        $body = file_get_contents(resource_path('views/mail_template/forgot_password.blade.php'));
        $body = str_replace($searchArr, $replaceArr, $body);
        $mail->MsgHTML($body);
        $mail->addAddress($contact->email, $contact->name);
        $mail->send();
        if ($mail) {
            return true;
        } else {
            return false;
        }
    }
}

if (!function_exists('uploadFile')) {
    function uploadFile($file, $location, $fileName = null)
    {
        if (!File::exists(public_path($location))) {
            mkdir(public_path($location), 0777, true);
        }
        if ($fileName == null) {
            list($name, $ext) = explode('.', $file->getClientOriginalName());
            $fileName = $name;
        }
        $fileName = str_replace(' ', '-', strtolower($fileName));
        $fileName = preg_replace('/[^A-Za-z0-9\-]/', '-', $fileName) . time() . '.' . $file->getClientOriginalExtension();
        $fileName = str_replace('--', '-', $fileName);
        $target = $location . $fileName;
        if (File::exists(public_path($target))) {
            $increment = 0;
            list($name, $ext) = explode('.', $fileName);
            while (File::exists(public_path($target))) {
                $increment++;
                $fileName = $name . '_' . $increment . '.' . $ext;
                $target = $location . $fileName;
            }
        }
        $file->move(public_path($location), $fileName);
        return $target;
    }
}

if (!function_exists('uploadWebpImage')) {
    function uploadWebpImage($file, $location, $fileName)
    {
        $fileName = str_replace(' ', '-', strtolower($fileName));
        $fileName = preg_replace('/[^A-Za-z0-9\-]/', '-', $fileName) . time() . '.webp';
        $fileName = str_replace('--', '-', $fileName);

        if (!File::exists(public_path($location))) {
            File::makeDirectory(public_path($location), 0777, true);
        }
        $target = $location . $fileName;
        if (File::exists(public_path($target))) {
            $increment = 0;
            list($name, $ext) = explode('.', $fileName);
            while (File::exists(public_path($target))) {
                $increment++;
                $fileName = $name . '_' . $increment . '.' . $ext;
                $target = $location . $fileName;
            }
        }
        Webp::make($file)->save(public_path($target));

        return $target;
    }
}


/**
 * print an image with webp on pages with picture tag.
 *
 * @param Collection $collection The eloquent collection.
 * @param string $field the name of the field.
 * @param string $webpField the name of the webp field.
 * @param string $attributeField the name of the attribute field.
 * @param string $cssClass the css class of the image.
 *
 * @return string html code for printing image on pages.
 */
if (!function_exists('printImage')) {
    function printImage($collection, $field, $webpField, $attributeField, $cssClass = null, $cssStyle = null)
    {
        $imageData = '<picture>';
        if (!empty($collection->$webpField) && File::exists(public_path($collection->$webpField))) {
            $imageData .= '<source srcset="' . asset($collection->$webpField) . '" type="image/webp">';
        }
        if (!empty($collection->$field) && File::exists(public_path($collection->$field))) {
            $imageData .= '<img src="' . asset($collection->$field) . '" ' . $collection->$attributeField;
        } else {
            if ($field == 'desktop_image' || $field == 'desktop_banner') {
                $imageData .= '<img src="' . asset('web/images/default-image-rect.jpg') . '" alt="Default Image"';
            } else if ($field == 'profile_image') {
                $imageData .= '<img src="' . asset('web/images/user-default.png') . '" alt="Default Image"';
            } else {
                $imageData .= '<img src="' . asset('web/images/default-image.jpg') . '" alt="Default Image"';
            }
        }
        if ($cssClass) {
            $imageData .= ' class="' . $cssClass . '"';
        }
        if ($cssStyle) {
            $imageData .= ' style="' . $cssStyle . '"';
        }
        $imageData .= ' ></picture>';
        return $imageData;
    }
}

/**
 * Delete file by checking it exixts
 *
 * @param Collection $collection The eloquent db collection.
 * @param string $fieldNAme The name field.
 *
 */
if (!function_exists('deleteFile')) {
    function deleteFile($collection, $fieldNAme)
    {
        if (File::exists(public_path($collection->$fieldNAme))) {
            File::delete(public_path($collection->$fieldNAme));
        }
    }
}

if (!function_exists('defaultLanguage')) {
    function defaultLanguage()
    {
        if (Session::has('language')) {
            $language = session('language');
        } else {
            $language = config('app.default_language');
        }
        App::setlocale($language);
        return $language;
    }
}

if (!function_exists('langString')) {
    function langString($collection, $field)
    {
        $defaultLang = defaultLanguage();
        if ($defaultLang == "en") {
            $langField = $field . '_en';
        } else if ($defaultLang == "ar") {
            $langField = $field . '_ar';
        } else {
            $langField = $field;
        }
        return $collection->$langField;
    }
}

if (!function_exists('staticLangString')) {
    /**
     * To Return English and Arabic value in Website Language table by given key
     * @param Collection $collection The eloquent db collection.
     * @param string $key value of key to be checked
     * @return boolean|string false if not found, value if it is found
     */
    function staticLangString($collection, $key)
    {
        $setting = $collection->where('key', $key)->first();
        if ($setting) {
            return langString($setting, 'value');
        }
        return FALSE;
    }
}

if (!function_exists('limit_text')) {
    function limit_text($text, $limit)
    {
        $text = strip_tags($text);
        if (str_word_count($text, 0) > $limit) {
            $words = str_word_count($text, 2);
            $pos = array_keys($words);
            $text = substr($text, 0, $pos[$limit]) . '...';
        }
        return $text;
    }
}

if (!function_exists('generateMaidId')) {
    function generateMaidId()
    {
       $latest_maid_id = Maid::latest()->first();
        $maid_id = 1;
        if($latest_maid_id)
            $maid_id = $latest_maid_id->maid_id; //latest maid id
        return ('TARGET_') . (substr($maid_id, 7) + 1);

    }
}


